REFINE_ANSWER_PROMPT = """
You are an expert QA system. Given a question, step-by-step thought process, and an initial answer, your task is to refine and improve the answer. Follow these steps:

1. Carefully review the question and the step-by-step thought process.
2. Evaluate the initial answer for accuracy and completeness.
3. Refine the answer by:
   - Correcting any errors or misconceptions
   - Adding any missing relevant information
   - Ensuring the answer directly addresses the question
   - Providing a concise and clear response
4. Format the final answer to match the style of the correct answers in the given examples.

Provide only the refined answer without any additional explanation or step-by-step process. Ensure the answer is concise and directly addresses the question. If the answer is a number or a short phrase, provide just that without additional context.
"""

FINAL_REFINEMENT_PROMPT = """
As an expert QA system, your task is to perform a final refinement of the answer. Given the original question, the initial answer, and the ensemble answer, follow these steps:

1. Carefully review the question to understand what is being asked.
2. Compare the initial answer and the ensemble answer for consistency and accuracy.
3. Identify any discrepancies or potential errors in either answer.
4. Refine the final answer by:
   - Correcting any errors or inconsistencies
   - Ensuring the answer is precise and directly addresses the question
   - Formatting the answer to match the expected output (e.g., single number, short phrase, or concise sentence)
   - Removing any unnecessary context or explanations

Provide only the final refined answer without any additional explanation. If the answer is a number, percentage, or short phrase, provide just that without additional context. Ensure the answer format matches the style of the correct answers in the given examples.
"""

FORMAT_CHECK_PROMPT = """
As a precise formatting expert, your task is to ensure the final answer matches the expected format of correct answers. Given the original question and the final answer, follow these steps:

1. Review the question to understand the required answer format.
2. Examine the final answer for any formatting issues.
3. Make corrections to the answer format, if necessary:
   - Remove unnecessary percentage signs
   - Ensure consistent decimal places (typically to two decimal places if applicable)
   - Remove any extraneous text or explanations
   - Convert word numbers to digits if appropriate
   - Ensure the answer is a single number, percentage, or short phrase without additional context

Provide only the corrected, formatted answer without any explanation. The output should be in the simplest, most concise form that accurately represents the answer to the question.
"""

ERROR_CORRECTION_PROMPT = """
As an error analysis and correction expert, your task is to review the question, step-by-step thought process, and the formatted answer to identify and correct any potential errors. Follow these steps:

1. Carefully review the question and the step-by-step thought process.
2. Examine the formatted answer for accuracy and relevance to the question.
3. Identify any potential errors, such as:
   - Incorrect number selection
   - Misinterpretation of the question
   - Calculation errors
   - Logical inconsistencies
4. If an error is found, correct it based on the information provided in the step-by-step thought process and the question.
5. Ensure the corrected answer is in the simplest, most concise form that accurately answers the question.

Provide only the corrected answer without any additional explanation. If no errors are found, return the original formatted answer. The output should be a single number, percentage, or short phrase without additional context, matching the format of the correct answers in the given examples.
"""

NUMERICAL_CHECK_PROMPT = """
As a numerical accuracy expert, your task is to perform a final check on the answer, focusing specifically on numerical values and calculations. Given the question, step-by-step thought process, and current answer, follow these steps:

1. Carefully review the question and the step-by-step thought process.
2. Examine the current answer, focusing on any numerical values or calculations.
3. Verify the accuracy of all numerical values and calculations by:
   - Cross-checking with the information provided in the question and thought process
   - Recalculating any mathematical operations
   - Ensuring correct units and conversions are used
4. If any numerical errors are found, correct them based on the information provided.
5. If the answer involves selecting the shortest, longest, highest, or lowest value, double-check that the correct extreme value has been chosen.
6. Ensure the final answer is presented in the simplest, most concise form that accurately answers the question.

Provide only the numerically verified and corrected answer without any additional explanation. If no errors are found, return the original answer. The output should be a single number, percentage, or short phrase without additional context, matching the format of the correct answers in the given examples.
"""

RANGE_CHECK_PROMPT = """
As a range analysis expert, your task is to perform a final check on the answer to ensure it falls within a reasonable range based on the context provided in the question. Given the question, step-by-step thought process, and current answer, follow these steps:

1. Carefully review the question and the step-by-step thought process to understand the context.
2. Examine the current answer and determine if it's within a reasonable range for the given context.
3. Consider the following factors when assessing the range:
   - The nature of the question (e.g., percentages, counts, years, measurements)
   - Any explicit or implicit constraints mentioned in the question
   - Common sense knowledge about the subject matter
4. If the answer falls outside a reasonable range, reconsider the calculation or logic used to arrive at the answer.
5. If necessary, adjust the answer to fall within a more plausible range based on the context.
6. Ensure the final answer is presented in the simplest, most concise form that accurately answers the question.

Provide only the range-verified and corrected answer without any additional explanation. If no adjustments are needed, return the original answer. The output should be a single number, percentage, or short phrase without additional context, matching the format of the correct answers in the given examples.
"""

CONTEXT_VERIFICATION_PROMPT = """
As a context-aware verification expert, your task is to perform a final check on the answer to ensure it is consistent with the information provided in the question. Given the question, step-by-step thought process, and current answer, follow these steps:

1. Carefully review the question and the step-by-step thought process to understand the context and given information.
2. Examine the current answer and verify its consistency with the information provided in the question.
3. Check for any contradictions or inconsistencies between the answer and the given context.
4. If any inconsistencies are found, revisit the step-by-step thought process to identify the source of the error.
5. If necessary, adjust the answer to align with the information provided in the question.
6. Ensure the final answer is presented in the simplest, most concise form that accurately answers the question and is consistent with the given context.

Provide only the context-verified and corrected answer without any additional explanation. If no adjustments are needed, return the original answer. The output should be a single number, percentage, or short phrase without additional context, matching the format of the correct answers in the given examples.
"""

PRECISION_CHECK_PROMPT = """
As a numerical precision expert, your task is to perform a final check on the answer to ensure it has the appropriate level of precision and is properly rounded. Given the question, step-by-step thought process, and current answer, follow these steps:

1. Carefully review the question and the step-by-step thought process to understand the required level of precision.
2. Examine the current answer and determine if it has the appropriate number of decimal places or significant figures.
3. Consider the following factors when assessing precision:
   - The nature of the question (e.g., percentages, counts, measurements)
   - The level of precision in the given data
   - Any explicit or implicit requirements for precision in the question
4. If the answer needs adjustment:
   - Round to the appropriate number of decimal places (typically two for percentages and financial figures)
   - Ensure consistency in precision across multiple numbers if applicable
   - Use proper rounding techniques (e.g., round half up)
5. If the answer is a whole number or doesn't require decimal places, ensure it's presented without any decimal point.
6. Format the final answer to match the style of the correct answers in the given examples.

Provide only the precision-adjusted answer without any additional explanation. If no adjustments are needed, return the original answer. The output should be a single number, percentage, or short phrase without additional context, matching the format of the correct answers in the given examples.
"""